/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.tcredstone.tile;

import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.tcredstone.block.BlockRedstoneAcceptor;
import com.troblecodings.tcredstone.init.GIRCInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileRedstoneEmitter
extends BlockEntity
implements ILinkableTile {
    private BlockPos linkedpos = null;
    private static final String ID_X = "xLinkedPos";
    private static final String ID_Y = "yLinkedPos";
    private static final String ID_Z = "zLinkedPos";

    public TileRedstoneEmitter(BlockPos pos, BlockState state) {
        super((BlockEntityType)GIRCInit.EMITER_TILE.get(), pos, state);
    }

    public static CompoundTag writeBlockPosToNBT(BlockPos pos, CompoundTag compound) {
        if (pos != null && compound != null) {
            compound.m_128405_(ID_X, pos.m_123341_());
            compound.m_128405_(ID_Y, pos.m_123342_());
            compound.m_128405_(ID_Z, pos.m_123343_());
        }
        return compound;
    }

    public static BlockPos readBlockPosFromNBT(CompoundTag compound) {
        if (compound != null && compound.m_128441_(ID_X) && compound.m_128441_(ID_Y) && compound.m_128441_(ID_Z)) {
            return new BlockPos(compound.m_128451_(ID_X), compound.m_128451_(ID_Y), compound.m_128451_(ID_Z));
        }
        return null;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.linkedpos = TileRedstoneEmitter.readBlockPosFromNBT(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        TileRedstoneEmitter.writeBlockPosToNBT(this.linkedpos, compound);
    }

    @Override
    public boolean link(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        this.linkedpos = pos;
        return true;
    }

    @Override
    public boolean unlink() {
        if (this.linkedpos == null) {
            return false;
        }
        this.linkedpos = null;
        return true;
    }

    public BlockPos getLinkedPos() {
        return this.linkedpos;
    }

    public void redstoneUpdate(boolean enabled) {
        TileRedstoneEmitter.redstoneUpdate(enabled, this.linkedpos, this.f_58857_);
    }

    public static boolean redstoneUpdate(boolean enabled, BlockPos linkedpos, Level level) {
        BlockState state;
        if (linkedpos != null && (state = level.m_8055_(linkedpos)).m_60734_() instanceof BlockRedstoneAcceptor) {
            level.m_7731_(linkedpos, (BlockState)state.m_61124_((Property)BlockRedstoneAcceptor.POWER, (Comparable)Boolean.valueOf(enabled)), 3);
        }
        return enabled;
    }

    public static boolean redstoneUpdate(BlockPos linkedpos, Level level) {
        BlockState state;
        if (linkedpos != null && (state = level.m_8055_(linkedpos)).m_60734_() instanceof BlockRedstoneAcceptor) {
            boolean newState = (Boolean)state.m_61143_((Property)BlockRedstoneAcceptor.POWER) == false;
            level.m_7731_(linkedpos, (BlockState)state.m_61124_((Property)BlockRedstoneAcceptor.POWER, (Comparable)Boolean.valueOf(newState)), 3);
            return newState;
        }
        return false;
    }

    @Override
    public boolean hasLink() {
        return this.linkedpos != null;
    }
}

